import minBy from 'lodash/minBy';

import SearchSegment from '../../interfaces/state/search/SearchSegment';

/**
 * getMinDurationSegment - находит сегмент с минимальным временем в пути.
 * Используется для построения текстового заголовка на странице поиска
 */
export default function getMinDurationSegment(
    segments: SearchSegment[],
): SearchSegment | undefined {
    return minBy(segments, 'duration');
}
