import SearchSegment from '../../interfaces/state/search/SearchSegment';
import FilteredSegmentIndexes from '../../interfaces/lib/segments/FilteredSegmentIndixes';
import Vector from '../../interfaces/lib/segments/Vector';

import isSegment from './isSegment';

export default function getNumberOfDirectSegments(
    vector: Vector,
    filteredSegmentIndexes: FilteredSegmentIndexes,
    segments: SearchSegment[],
): number {
    return vector
        .filter(index => filteredSegmentIndexes[index])
        .reduce((count, index) => {
            const segment = segments[index];

            if (isSegment(segment)) {
                count++;
            }

            return count;
        }, 0);
}
