import RenderMode from '../../interfaces/RenderMode';

/*
 * Метод ограничивает количество отображаемых сегментов в зависимости от окружения:
 * для сервера мы генерируем ограниченное число сегментов (если запрос от поискового бота -
 * тогда отдаем сразу все сегменты), а на клиенте производим полную отрисовку.
 * @param {numbers[]} vector - массив индексов сегментов
 * @param {boolean[]} filteredSegmentIndices - массив фильтрации сегментов
 * @param {Object} environment - объект окружения приложения
 * @returns {number[]}
 */
export default function getPreviewVector({
    vector = [],
    filteredSegmentIndices = [],
    environment,
}) {
    const {renderMode, segmentsLimitRender} = environment;
    let limit = segmentsLimitRender;

    return renderMode === RenderMode.light
        ? vector.filter(vectorIndex => {
              if (limit > 0 && filteredSegmentIndices[vectorIndex]) {
                  limit--;

                  return true;
              }

              return false;
          })
        : vector;
}
