import {CHAR_EM_DASH} from '../stringUtils';

/**
 * Возвращает заголовок для сегмента
 * @param {string} title
 * @param {Object} stationFrom
 * @param {Object} stationTo
 * @return {string}
 */
export default function getSegmentTitle({title, stationFrom, stationTo}) {
    return (
        title ||
        (stationTo && stationTo.title && stationFrom && stationFrom.title
            ? `${stationFrom.title} ${CHAR_EM_DASH} ${stationTo.title}`
            : '')
    );
}
