import keyset from '../../i18n/coach-types';

// Функция возвращает сокращенные названия классов вагонов
export default function getShortTariffClassName(
    tariffClass?: string,
    useShorter?: boolean,
): string {
    return (
        (useShorter && keyset.get(`${tariffClass}-short-short`)) ||
        keyset.get(`${tariffClass}-short`) ||
        (tariffClass && keyset.get(tariffClass)) ||
        ''
    );
}
