import {FilterTransportType} from '../transportType';

import {isStation} from '../point/pointType';

/*
 * Метод определяет необходимость отображения наименования станций для сегментов
 * @param {numbers[]} vector - массив индексов сегментов
 * @param {boolean[]} filteredSegmentIndices - массив фильтрации сегментов
 * @param {Object} context - поисковый контекст
 * @param {Object[]} segments - массив сгментов
 * @returns {Object}
 */
export default function getStationsVisibility({
    vector,
    filteredSegmentIndices,
    context,
    segments,
}) {
    const hideStations = isStation(context.from) && isStation(context.to);
    let wasFound = false;
    const stationsVisibility = {};

    vector.forEach(index => {
        const isVisible = filteredSegmentIndices[index];

        if (context.transportType === FilterTransportType.train) {
            stationsVisibility[index] = true;

            return;
        }

        if (
            !hideStations ||
            (isVisible && !wasFound && !segments[index].isTransfer)
        ) {
            wasFound = true;
            stationsVisibility[index] = true;
        } else {
            stationsVisibility[index] = false;
        }
    });

    return stationsVisibility;
}
