import IStateFlags from '../../interfaces/state/flags/IStateFlags';
import ISegment from '../../interfaces/segment/ISegment';
import ITransfer from '../../interfaces/transfer/ITransfer';
import ITransferSegment from '../../interfaces/transfer/ITransferSegment';
import ISearchSort from '../../interfaces/state/search/ISearchSort';
import ISegmentTariffClass from '../../interfaces/segment/ISegmentTariffClass';
import IStateSeoQueryParams from '../../interfaces/state/IStateSeoQueryParams';

import {sortTariffClassKeys} from './getBaseTariffClassKeys';
import {makeCacheable} from '../cache';
import getPurchaseLinkObject from './getPurchaseLinkObject';

interface IGetTariffKeysResult {
    tariffKeys: string[];
    mainTariffKey: ISegmentTariffClass | null;
}

const defaultResult = {
    tariffKeys: [],
    mainTariffKey: null,
};

// Возвращает ключи тарифов и главный тариф
const getTariffKeys = makeCacheable(
    (
        segment: ISegment | ITransfer | ITransferSegment,
        flags: IStateFlags,

        seoQueryParams?: IStateSeoQueryParams,
        sort?: ISearchSort,
    ): IGetTariffKeysResult => {
        if (!segment) {
            // Для js-кода
            return defaultResult;
        }

        const {tariffs} = segment;

        if (!tariffs || !tariffs.classes) {
            return defaultResult;
        }

        const tariffClassKeys: string[] = sortTariffClassKeys({
            tariffClassKeys: segment.tariffClassKeys || [],
            segment,
            sort,
        });
        const orderClassKey = tariffClassKeys.find(classKey => {
            const purchaseLinkObject = getPurchaseLinkObject({
                segment,
                tariffClass: tariffs.classes[classKey],
                seoQueryParams,
            });

            return purchaseLinkObject.href;
        });

        return {
            tariffKeys: tariffClassKeys,
            mainTariffKey: orderClassKey
                ? tariffs.classes[orderClassKey]
                : null,
        };
    },
);

export default getTariffKeys;
