// Возвращает число от 0 до 1. Чем выше число, тем больше тариф подходит к сегменту
export default function getTariffMatchWeigh(
    segment: {tariffsKeys?: string[]},
    tariff: {keys?: string[]; key?: string},
): number {
    const {tariffsKeys} = segment;
    const {keys, key} = tariff;

    if (tariffsKeys) {
        if (keys) {
            const keyIndex = keys.findIndex(item => tariffsKeys.includes(item));

            if (keyIndex >= 0) {
                return 1 - keyIndex / keys.length;
            }

            return 0;
        }

        if (key) {
            return tariffsKeys.includes(key) ? 1 : 0;
        }
    }

    return 0;
}
