import {TRAIN_TYPE} from '../transportType';

/**
 * Возвращает процентное соотношение сегментов определенного типа транспорта ко всем сегментам
 * @param {Object[]} segments - массив сегментов
 * @param {string} transportType - тип транспорта
 * @return {number}
 */
export function getTransportTypeRatio(segments, transportType) {
    const selectedSegments = segments.filter(
        ({transport}) => transport.code === transportType,
    );

    return (100 * selectedSegments.length) / segments.length;
}

/**
 * Возвращает процентное соотношение поездов ко остальным сегментам
 * @param {Object[]} segments - массив сегментов
 * @return {number}
 */
export function getTrainSegmentsRatio(segments) {
    return getTransportTypeRatio(segments, TRAIN_TYPE);
}
