import {makeCacheable} from '../cache';

const getTransportTypes = makeCacheable(segments =>
    Array.from(
        segments.reduce((types, segment) => {
            if (segment.isTransfer) {
                segment.segments.forEach(transferSegment =>
                    types.add(transferSegment.transport.code),
                );
            } else {
                types.add(segment.transport.code);
            }

            return types;
        }, new Set()),
    ),
);

export default getTransportTypes;
