/**
 * Возвращает сегменты, отфильтрованные и разбитые при помощи filterManager'а
 * @param {Object} filterManager
 * @param {Array} segments
 * @param {Object} context
 * @return {Array}
 */
export default function groupFilteredSegments({
    filterManager,
    segments,
    context,
}) {
    const result = [];

    if (!filterManager.isAvailableForContext(context)) {
        return result;
    }

    const options = filterManager.getOptions(segments);

    options.forEach(option => {
        let value;
        let text;

        // На случай, если опции у manager'а передаются в виде простого текста
        if (typeof option === 'string') {
            value = option;
            text = filterManager.getOptionText(option);
        } else {
            value = option.value;
            text = option.text;
        }

        const segmentIndices = filterManager.getFilteredSegmentIndices(
            value,
            segments,
        );
        const optionSegments = [];

        segmentIndices.forEach((segmentIndex, index) => {
            if (segmentIndex) {
                optionSegments.push(segments[index]);
            }
        });

        result.push({title: text, segments: optionSegments, key: value});
    });

    return result;
}
