import {TransportType} from '../transportType';
import ISegment from '../../interfaces/segment/ISegment';
import ITransferSegment from '../../interfaces/transfer/ITransferSegment';
import ITransfer from '../../interfaces/transfer/ITransfer';

import isCppkCompany from './isCppkCompany';

export default function isCppk(
    segment: ISegment | ITransferSegment | ITransfer,
): boolean {
    if (!('company' in segment)) {
        return false;
    }

    const companyIsCppk = isCppkCompany(segment);

    const {
        transport: {code},
        trainPurchaseNumbers,
    } = segment;

    return (
        companyIsCppk &&
        (code === TransportType.train ||
            (code === TransportType.suburban && Boolean(trainPurchaseNumbers)))
    );
}
