import ISegment from '../../interfaces/segment/ISegment';
import ITransfer from '../../interfaces/transfer/ITransfer';
import ITransferSegment from '../../interfaces/transfer/ITransferSegment';

const CPPK_ID = 153;

export default function isCppkCompany(
    segment: ISegment | ITransferSegment | ITransfer,
): boolean {
    if (!('company' in segment)) {
        return false;
    }

    return segment.company?.id === CPPK_ID;
}
