import SegmentSubtypeCode from '../../interfaces/segment/SegmentSubtypeCode';
import ISegmentFromApi from '../../interfaces/segment/ISegmentFromApi';
import ITransferFromApi from '../../interfaces/transfer/ITransferFromApi';
import {TransportType} from '../transportType';

import isTransfer from './isTransfer';

export default function IsLastochka(
    segment: ISegmentFromApi | ITransferFromApi,
): boolean {
    const {transport} = segment;
    const {code, subtype} = transport;

    if (isTransfer(segment)) {
        return false;
    }

    if (code === TransportType.suburban) {
        return Boolean(
            subtype && subtype.code === SegmentSubtypeCode.lastochka,
        );
    }

    if (code === TransportType.train) {
        return Boolean(
            subtype && subtype.code === SegmentSubtypeCode.lastochkaDal,
        );
    }

    return false;
}
