import {TIMES_RANGES} from '../date/values';

import TimeOfDay from '../../interfaces/date/TimeOfDay';
import ISegment from '../../interfaces/segment/ISegment';

import {getSegmentTimes} from './cachedSegmentTime';

// Определяет, является ли сегмент ночным - находится ли пассажир в три часа ночи по местному времени внутри поезда.
export default function isOvernight(segment: ISegment): boolean {
    let {departureMoment, arrivalMoment} = segment;

    if (!departureMoment || !arrivalMoment) {
        const times = getSegmentTimes(segment);

        departureMoment = times.departureMoment;
        arrivalMoment = times.arrivalMoment;
    }

    const nightRange = TIMES_RANGES[TimeOfDay.night];

    // Час суток, на который приходится середина ночи.
    const nightMiddleHour = (nightRange.end - nightRange.start) / 2;

    const departure = departureMoment
        .clone()
        .subtract(nightMiddleHour, 'hours');
    const arrival = arrivalMoment.clone().subtract(nightMiddleHour, 'hours');

    return (
        departure.year() !== arrival.year() ||
        departure.month() !== arrival.month() ||
        departure.date() !== arrival.date()
    );
}
