import AllSegmentType from '../../interfaces/segment/AllSegmentType';
import ISegmentFromApi from '../../interfaces/segment/ISegmentFromApi';

import isTransferFromApi from './isTransferFromApi';
import isTransferSegmentFromApi from './isTransferSegmentFromApi';
import isSubSegmentFromApi from './isSubSegmentFromApi';

export default function isSegmentFromApi(
    segment: AllSegmentType,
): segment is ISegmentFromApi {
    return (
        !isTransferFromApi(segment) &&
        !isTransferSegmentFromApi(segment) &&
        !isSubSegmentFromApi(segment)
    );
}
