import {UA} from '../countries';

/**
 * Проверка, что у сегмента страна станции отправления или станции прибытия не находится в Украине.
 *
 * @param {Object} stationFrom - объект станции отправления поезда
 * @param {Object} stationTo - объект станции прибытия поезда
 * @return {boolean}
 */
export default function isUkrainianSegment({stationFrom, stationTo}) {
    return Boolean(
        stationFrom &&
            stationTo &&
            stationFrom.country &&
            stationTo.country &&
            (stationFrom.country.code === UA || stationTo.country.code === UA),
    );
}
