import getLowestPrice from './getLowestPrice';
import isPriceGreater from './isPriceGreater';

/**
 * Метод определяет содержит ли сегмент для сравнения более дешевые цены
 * @param {Object} baseSegment - базовый сегмент
 * @param {Object} updateSegment - сегмент для сравнения
 * @return {boolean}
 */
export default function isUpdateCheaper(baseSegment, updateSegment) {
    const baseCheapestPrice = getLowestPrice(baseSegment);
    const updateCheapestPrice = getLowestPrice(updateSegment);

    const basePriceIsDefined = Boolean(baseCheapestPrice);
    const updatePriceIsDefined = Boolean(updateCheapestPrice);

    if (basePriceIsDefined && updatePriceIsDefined) {
        return isPriceGreater(baseCheapestPrice, updateCheapestPrice);
    }

    if (!basePriceIsDefined && updatePriceIsDefined) {
        return true;
    }

    return false;
}
