import {USSR_COUNTRIES} from '../countries';

/**
 * Проверка, что нитка начинается или заканчивается в пределах бывшего СССР.
 *
 * @param {Object} thread - объект нитки
 * @return {boolean}
 */
export default function isUssrThread(thread) {
    // firstCountryCode - страна начала нитки
    // lastCountryCode - страна конца нитки
    return Boolean(
        thread &&
            thread.firstCountryCode &&
            thread.lastCountryCode &&
            USSR_COUNTRIES.includes(thread.firstCountryCode) &&
            USSR_COUNTRIES.includes(thread.lastCountryCode),
    );
}
