import ISegmentFromBackend from '../../interfaces/segment/ISegmentFromBackend';
import ISegmentFromApi from '../../interfaces/segment/ISegmentFromApi';

export default function patchSegmentsFromBackend(
    segments: ISegmentFromBackend[],
): ISegmentFromApi[] {
    return segments.map(segment => {
        const {subSegments, codeshares, tariffsKeys} = segment;
        const allTariffsKeys = new Set(tariffsKeys);

        // Добавляем ключи кодшерных рейсов, чтобы при опросе авиа-тарифов,
        // тарифы кодшеров мержились к основному сегменту, а не создавали новые сегменты
        if (codeshares) {
            codeshares.forEach(codeshare => {
                codeshare.tariffsKeys.forEach(tariffKey => {
                    allTariffsKeys.add(tariffKey);
                });
            });
        }

        return {
            ...segment,
            isMetaSegment: Boolean(subSegments && subSegments.length),
            subSegments: subSegments
                ? subSegments.map(subSegment => ({
                      ...subSegment,
                      isSubSegment: true,
                  }))
                : undefined,
            tariffsKeys: [...allTariffsKeys],
        };
    });
}
