import {
    CHAR_NBSP,
    CHAR_EM_DASH,
    CHAR_DASH,
    CHAR_MIDDLE_DASH,
} from '../stringUtils';

const regExpTitle = new RegExp(`\\s[${CHAR_DASH}${CHAR_MIDDLE_DASH}]\\s`, 'g');
const dashRegexp = new RegExp('(\\s[-—])(\\s)');
const shortWordRegexp = new RegExp('([^-—])((\\s)(\\S{1,5}))$');

/**
 * Редактирует заголовок для четырёх кейсов:
 *   - Заменять короткие и средние тире окруженные пробелами на длинные тире
 *   - Подставлять неразрывный пробел перед длинным тире
 *   - Подставлять неразрывный пробел перед короткими словами в конце заголовка
 * Задача №1: RASPFRONT-2004 - Оформление и типографика в сниппете
 * Задача №2: RASPFRONT-6544 - В названии маршрута в поиске только первый дефис заменяется на тире
 * @param {string} title - строка заголовка сегмента
 * @return {string}
 */
export default function patchTitle(title) {
    if (title) {
        title = title.replace(regExpTitle, ` ${CHAR_EM_DASH} `);
        title = title.replace(dashRegexp, `${CHAR_NBSP}${CHAR_EM_DASH}$2`);
        title = title.replace(shortWordRegexp, `$1${CHAR_NBSP}$4`);
    }

    return title;
}
