import {TransportType} from '../transportType';

import ISearchQuerying from '../../interfaces/state/search/ISearchQuerying';
import ISegment from '../../interfaces/segment/ISegment';
import ITransfer from '../../interfaces/transfer/ITransfer';
import ITransferSegment from '../../interfaces/transfer/ITransferSegment';

import isSegment from './isSegment';
import isTransfer from './isTransfer';
import isTransferSegment from './isTransferSegment';

// Вернёт признак, что для данного сегмента/пересадки/сегмента_пересадки происходит опрос цен
export default function isPriceQuerying(
    querying: ISearchQuerying,
    segment: ISegment | ITransfer | ITransferSegment,
): boolean {
    const {
        plane: queryingPlane,
        train: queryingTrain,
        transferAll: queryingTransferAll,
        transferTrain: queryingTransferTrain,
        transferPlane: queryingTransferPlane,
    } = querying;
    const transportType = segment.transport.code;

    if (isSegment(segment)) {
        const {isInterval} = segment;

        if (isInterval) {
            return false;
        }

        if (queryingPlane) {
            return true;
        }

        if (queryingTrain) {
            const hasTrainTariffs = Boolean(segment.hasTrainTariffs);

            return (
                transportType === TransportType.train ||
                (transportType === TransportType.suburban && hasTrainTariffs)
            );
        }
    }

    if (isTransferSegment(segment)) {
        if (transportType === TransportType.train) {
            return Boolean(queryingTransferAll || queryingTransferTrain);
        }

        if (transportType === TransportType.plane) {
            return Boolean(queryingTransferAll || queryingTransferPlane);
        }
    }

    // интерлайны
    if (
        isTransfer(segment) &&
        segment.segments.every(
            ({transport: {code}}) => code === TransportType.plane,
        )
    ) {
        return Boolean(queryingTransferAll || queryingTransferPlane);
    }

    return false;
}
