import DateSpecialValue from '../../../interfaces/date/DateSpecialValue';

import isRidesharingAvailableForRequest from './isRidesharingAvailableForRequest';
import isRidesharingEnabled from './isRidesharingEnabled';

/**
 * Метод определяет доступность отображения блока блаблакара
 * @param {Object} context - контекст поиска
 * @param {Object} blablacar - объект блаблакара (ответ соответствующей ручки)
 * @param {Object} flags - объект с флагами
 * @return {boolean}
 */
export default function isRidesharingAvailableForDisplay(
    context,
    blablacar,
    flags,
) {
    if (!isRidesharingEnabled(flags)) {
        return false;
    }

    const {searchForPastDate, from, to} = context;

    const bbkIsAvailableForRequest = isRidesharingAvailableForRequest({
        searchForPastDate,
        from,
        to,
        flags,
    });

    if (bbkIsAvailableForRequest && blablacar && !blablacar.banned) {
        const {querying, tariff, allDaysCheckComplete, allDaysCheckResult} =
            blablacar;
        const noResultsOnDate =
            !tariff?.offersCount && Boolean(allDaysCheckResult);

        // Это условие появилось в рамках задачи https://st.yandex-team.ru/RASPFRONT-7838
        // При возобновлении нормальной работы ББК нужно оторвать
        if (noResultsOnDate) {
            return false;
        }

        if (querying || (tariff && tariff.offersCount)) {
            return true;
        }

        if (context.when.special !== DateSpecialValue.allDays) {
            return allDaysCheckComplete ? allDaysCheckResult !== null : true;
        }
    }

    return false;
}
