import IStateFlags from 'common/interfaces/state/flags/IStateFlags';
import IPoint from 'common/interfaces/state/searchForm/IPoint';
import {BY} from '../../countries';

import isRidesharingEnabled from './isRidesharingEnabled';

interface IRidesharingAvailableParams {
    searchForPastDate: boolean;
    from: IPoint;
    to: IPoint;
    flags: IStateFlags;
}

/**
 * Метод определяющий необходимость запроса к ручке блаблакара
 * @param from - объект места отправления
 * @param to - объект места прибытия
 * @param flags - объект с флагами
 * @param searchForPastDate - флаг поиска на прошедшую дату
 */
export default function isRidesharingAvailableForRequest({
    searchForPastDate,
    from,
    to,
    flags,
}: IRidesharingAvailableParams): boolean {
    return Boolean(
        isRidesharingEnabled(flags) &&
            from?.country &&
            to?.country &&
            !(from.country.code === BY && to.country.code === BY) &&
            !searchForPastDate,
    );
}
