import {momentTimezone as moment} from '../../../reexports';

import {MOMENT} from '../date/formats';
import {TRAIN_TYPE} from '../transportType';

export default function shouldRemoveTariffs(segment, {now}) {
    if (segment.transport.code !== TRAIN_TYPE) {
        return false;
    }

    const departure = moment(segment.departure, MOMENT);
    const removeTariffsBefore = moment(now);

    removeTariffsBefore.add(1, 'hour');

    return departure.isBefore(removeTariffsBefore);
}
