import {YBUS} from './tariffSources';
import {
    BUS_TYPE,
    TRAIN_TYPE,
    PLANE_TYPE,
    SUBURBAN_TYPE,
} from '../transportType';

import shouldUseLinkToTrains from '../order/shouldUseLinkToTrains';

import commonKeyset from '../../i18n/common/index';

/**
 * Вернёт текст для главной кнопки сегмента
 * @param {Object} segment - данные сегмента
 * @return {string}
 */
export function getBuyLinkText(segment) {
    const {
        source,
        transport: {code: transportType},
    } = segment;

    if (transportType === PLANE_TYPE) {
        return commonKeyset('buy-ticket');
    }

    if (transportType === BUS_TYPE && source === YBUS) {
        return commonKeyset('buy-on-yandex-bus');
    }

    if (transportType === TRAIN_TYPE) {
        return shouldUseLinkToTrains(segment)
            ? commonKeyset('select-place')
            : commonKeyset('buy-on-ufs');
    }

    if (transportType === SUBURBAN_TYPE && segment.hasTrainTariffs) {
        return commonKeyset('select-place');
    }

    return commonKeyset('buy');
}
