import {SUBURBAN_TYPE} from '../transportType';

export function excludeSuburbanSegmentsOfWrongPlan({segments, plans}, plan) {
    const currentPlanCode =
        plan || (plans && plans.current && plans.current.code);

    if (!currentPlanCode) {
        return segments;
    }

    return segments.filter(
        ({transport, thread}) =>
            transport.code !== SUBURBAN_TYPE ||
            !thread.schedulePlanCode ||
            thread.schedulePlanCode === currentPlanCode,
    );
}
