import {
    BUS_TYPE,
    PLANE_TYPE,
    TRAIN_TYPE,
    SUBURBAN_TYPE,
} from '../transportType';

// автобусы
export const BUS = 'bus';
export const BUS_TARIFF_CLASSES = [BUS];

// поезда
export const PLATZKARTE = 'platzkarte'; // плацкарт
export const COMPARTMENT = 'compartment'; // купе
export const SUITE = 'suite'; // св
export const COMMON = 'common'; // общие
export const SITTING = 'sitting'; // сидячие

export const CLASSES_WITH_GENDER_TYPE = [COMPARTMENT, SUITE];
export const CLASSES_WITH_UPPER_LOWER_PLACES = [PLATZKARTE, COMPARTMENT, SUITE];
export const TRAIN_TARIFF_CLASSES = [
    PLATZKARTE,
    COMPARTMENT,
    SUITE,
    COMMON,
    SITTING,
];

// Классы тарифов, упорядоченные для дневных поездов. Сидячка и общий - в начале списка.
export const TRAIN_TARIFF_CLASSES_DAY = [
    SITTING,
    COMMON,
    PLATZKARTE,
    COMPARTMENT,
    SUITE,
];

// самолеты
export const ECONOMY = 'economy';
export const BUSINESS = 'business';
export const PLANE_TARIFF_CLASSES = [ECONOMY, BUSINESS];

// электрички
export const SUBURBAN = 'suburban';
export const SUBURBAN_TARIFF_CLASSES = [SUBURBAN];

export const TARIFF_CLASSES_BY_TYPE = {
    [BUS_TYPE]: BUS_TARIFF_CLASSES,
    [PLANE_TYPE]: PLANE_TARIFF_CLASSES,
    [TRAIN_TYPE]: TRAIN_TARIFF_CLASSES,
    [SUBURBAN_TYPE]: SUBURBAN_TARIFF_CLASSES,
};

// ссылки на покупку
export enum OrderUrlOwner {
    trains = 'trains',
    ufs = 'ufs',
}
