import {TransportType} from '../../transportType';
import ISegmentFromApi from '../../../interfaces/segment/ISegmentFromApi';
import ITransferSegmentFromApi from '../../../interfaces/transfer/ITransferSegmentFromApi';

import isSegment from '../isSegment';
import isTransferSegment from '../isTransferSegment';

// Вернёт признак применимости жд тарифов к сегменту
export default function areTrainTariffsAvailableForSegment(
    segment: ISegmentFromApi | ITransferSegmentFromApi,
): boolean {
    const transportType = segment.transport.code;

    return (
        transportType === TransportType.train ||
        ((isSegment(segment) || isTransferSegment(segment)) &&
            transportType === TransportType.suburban &&
            segment.hasTrainTariffs === true)
    );
}
