import {momentTimezone as moment} from '../../../../reexports';

import SearchSegment from '../../../interfaces/state/search/SearchSegment';

import isSegment from '../isSegment';
import areTrainTariffsAvailableForSegment from './areTrainTariffsAvailableForSegment';

type TimeRangeResult = {
    startTime: string;
    endTime: string;
} | null;

// Возвращает временной интервал, покрывающий сегменты, для запроса за ценами в бэкенд.
export default function getTimeRangeForTrainTariffs(
    segments: SearchSegment[],
): TimeRangeResult {
    const filteredSegments = segments.filter(segment => {
        if (!isSegment(segment)) {
            // цены для пересадок запрашиваются через ручку transfersWithPrices
            // и для них не требуется определять временной интервал
            return false;
        }

        return areTrainTariffsAvailableForSegment(segment);
    });

    if (!filteredSegments.length) {
        return null;
    }

    const minDeparture = filteredSegments.reduce(
        (min, {departure}) => (departure < min ? departure : min),
        filteredSegments[0].departure,
    );
    const maxDeparture = filteredSegments.reduce(
        (max, {departure}) => (departure > max ? departure : max),
        filteredSegments[0].departure,
    );

    return {
        startTime: minDeparture,
        endTime: moment.parseZone(maxDeparture).add(1, 'minutes').format(),
    };
}
