import ISegmentFromBackend from '../../../interfaces/segment/ISegmentFromBackend';
import ITransferSegmentFromBackend from '../../../interfaces/transfer/ITransferSegmentFromBackend';
import ITransferFromBackend from '../../../interfaces/transfer/ITransferFromBackend';

/*
Возвращает признак того, что сегмент/пересадка/сегмент_пересадки имеет хотя бы один класс тарифа
с ценой и положительным количеством мест
*/
export default function havePriceAndSeats(
    segment:
        | ISegmentFromBackend
        | ITransferFromBackend
        | ITransferSegmentFromBackend,
): boolean {
    const {tariffs} = segment;

    if (!tariffs) {
        return false;
    }

    const tariffClasses = Object.values(tariffs.classes);

    return tariffClasses.some(tariff => {
        const haveSeats =
            typeof tariff.seats !== 'undefined' ? Boolean(tariff.seats) : true;
        const havePrice = Boolean(tariff.price && tariff.price.value);

        return haveSeats && havePrice;
    });
}
