import {SUBURBAN_TYPE} from '../../transportType';
import {TARIFF_CLASSES_BY_TYPE} from '../tariffClasses';

import isAllDaysSearch from '../../search/isAllDaysSearch';

/**
 * По тарифам определяет к какому типу транспорта они относятся
 * Примечание: возможно в будущем возможно пересечение имён классов (эконом, бизне-класс и т.д.)
 * @param {Object} tariffs - данные тарифов
 * @return {string|null}
 */
export function getTariffsType(tariffs) {
    const classes = tariffs && tariffs.classes;
    const classesKeys = classes && Object.keys(classes);

    if (!classesKeys || !classesKeys.length) {
        return null;
    }

    return (
        Object.keys(TARIFF_CLASSES_BY_TYPE).find(type => {
            const typeClasses = TARIFF_CLASSES_BY_TYPE[type];

            return classesKeys.every(classKey =>
                typeClasses.includes(classKey),
            );
        }) || null
    );
}

/**
 * Проверяет, являются ли тарифы электричечными
 * @param {Object} tariffs - данные тарифов
 * @return {boolean}
 */
export function isSuburbanTariffs(tariffs) {
    return getTariffsType(tariffs) === SUBURBAN_TYPE;
}

/**
 * Проверяет возможность отображения электричечных тарифов
 *
 * @param {Object} context
 * @param {Object} segment
 *
 * @return {boolean}
 */
export function shouldShowSuburbanTariffs(context, segment) {
    const {tariffs, queryingPrices, hasTrainTariffs} = segment;

    if (!isSuburbanTariffs(tariffs)) {
        return false;
    }

    const {suburbanCategories} = tariffs;

    if (suburbanCategories) {
        const categoriesLength = Object.values(suburbanCategories).reduce(
            (result, category) => result + category.length,
            0,
        );

        if (categoriesLength <= 1) {
            return false;
        }
    }

    return (
        isAllDaysSearch(context) || (hasTrainTariffs ? !queryingPrices : true)
    );
}
