import {momentTimezone as moment} from '../../../../reexports';

import Lang from '../../../interfaces/Lang';
import {FilterTransportType} from '../../transportType';
import ITransferFromBackend from '../../../interfaces/transfer/ITransferFromBackend';
import ITransferFromApi from '../../../interfaces/transfer/ITransferFromApi';

import getAggregatedInfo from './getAggregatedInfo';

interface IBuildTransferSegment {
    transfer: ITransferFromBackend;
    language: Lang;
    transportType: FilterTransportType;
}

// Патчинг исходного объекта пересадочника в сегмент удобный для выдачи
export function buildTransferSegment({
    transfer,
    language,
    transportType,
}: IBuildTransferSegment): ITransferFromApi {
    const segments = transfer.segments.map(segment => ({
        isTransferSegment: true,
        title: segment.thread.title,
        number: segment.thread.number,
        ...segment,
    }));
    const firstSegment = segments[0];
    const lastSegment = segments[segments.length - 1];

    const {transferStations, transferTitle} = getAggregatedInfo({
        transfer,
        language,
        transportType,
    });

    return {
        ...transfer,
        segments,
        transport: firstSegment.transport,
        isInterval: false,
        isTransfer: true,
        departure: firstSegment.departure,
        arrival: lastSegment.arrival,
        duration: moment(lastSegment.arrival).diff(
            moment(firstSegment.departure),
            'seconds',
        ),
        stationFrom: firstSegment.stationFrom,
        stationTo: lastSegment.stationTo,
        transferStations,
        transferTitle,
        title: transferTitle,
    };
}

interface IBuildSegmentsFromTransfers {
    transfers: ITransferFromBackend[];
    language: Lang;
    transportType: FilterTransportType;
}

export function buildSegmentsFromTransfers({
    transfers,
    language,
    transportType,
}: IBuildSegmentsFromTransfers): ITransferFromApi[] {
    return transfers.map(transfer =>
        buildTransferSegment({transfer, language, transportType}),
    );
}
