import moment from 'moment';

import ITransferSegmentFromBackend from '../../../interfaces/transfer/ITransferSegmentFromBackend';

// функция-костыль для генерации id сегмента пересадок для ручки searchTransfer2,
// аналогично тому как приходят данные из ручки transfersWithPrices
// id: 2000003-9606620-2019-08-16T12:30-train
export default function generateIdForTransferSegment(
    transferSegment: ITransferSegmentFromBackend,
): string {
    const {
        stationFrom: {id: stationFromId},
        stationTo: {id: stationToId},
        departure,
        transport: {code: transportType},
    } = transferSegment;

    const departureFormatted = moment
        .parseZone(departure)
        .format('YYYY-MM-DDTHH:mm');

    return `${stationFromId}-${stationToId}-${departureFormatted}-${transportType}`;
}
