import {CHAR_NBSP, CHAR_RIGHT_ARROW} from '../../stringUtils';

import ITransferSegment from '../../../interfaces/transfer/ITransferSegment';
import ITransferStationSettlement from '../../../interfaces/transfer/ITransferStationSettlement';
import ITransferStation from '../../../interfaces/transfer/ITransferStation';
import Keyset from '../../../interfaces/Keyset';

import segmentTransferKeyset from '../../../i18n/segment-transfer';

function getShortTransferDescription(
    transferPoint: ITransferStation | ITransferStationSettlement,
    keyset: Keyset,
): string {
    if (transferPoint.titleLocative && transferPoint.preposition) {
        return keyset('transfer-point-description-short-locative', {
            transferPoint: transferPoint.titleLocative,
            preposition: transferPoint.preposition,
        });
    }

    return keyset('transfer-point-description-short-infinitive', {
        transferPoint: transferPoint.title,
    });
}

function getFullTransferDescription(
    settlement: ITransferStationSettlement,
    stationTitle: string,
    keyset: Keyset,
): string {
    if (settlement.titleLocative && settlement.preposition) {
        return keyset('transfer-point-description-full-locative', {
            settlement: settlement.titleLocative,
            settlementPreposition: settlement.preposition,
            station: stationTitle,
        });
    }

    return keyset('transfer-point-description-full-infinitive', {
        settlement: settlement.title,
        station: stationTitle,
    });
}

export function getTransferPointDescription(
    segment: ITransferSegment,
    nextSegment: ITransferSegment,
): string {
    const {stationTo} = segment;

    const settlement = stationTo.settlement;

    if (settlement) {
        let station = stationTo.popularTitle || stationTo.title;
        const nextSegmentFrom = nextSegment.stationFrom;

        if (
            stationTo.id === nextSegmentFrom.id &&
            station.includes(settlement.title)
        ) {
            return getShortTransferDescription(
                settlement,
                segmentTransferKeyset,
            );
        }

        if (stationTo.id !== nextSegmentFrom.id) {
            const nextStation =
                nextSegmentFrom.popularTitle || nextSegmentFrom.title;

            station += `${CHAR_NBSP}${CHAR_RIGHT_ARROW} ${nextStation}`;
        }

        return getFullTransferDescription(
            settlement,
            station,
            segmentTransferKeyset,
        );
    }

    return getShortTransferDescription(stationTo, segmentTransferKeyset);
}
