import {COMPANY} from './features';

import ISegmentCompany from '../../../interfaces/segment/ISegmentCompany';
import ITransportFeature from '../../../interfaces/lib/segments/ITransportFeature';
import Tld from '../../../interfaces/Tld';
import Lang from '../../../interfaces/Lang';

import getAviaCompanyLink from '../../url/getAviaCompanyLink';

// Вернёт список компаний сегмента
export default function getCompanies(
    tld: Tld,
    language: Lang,
    company?: ISegmentCompany,
    companies?: ISegmentCompany[],
): ITransportFeature[] {
    return (companies || (company && [company]) || []).reduce(
        (result, companyData): ITransportFeature[] => {
            const {shortTitle, title, id, hidden, yandexAviaUrl} = companyData;

            const companyTitle = shortTitle || title;

            if (companyTitle) {
                result.push({
                    type: COMPANY,
                    props:
                        id && !hidden
                            ? {
                                  href: yandexAviaUrl
                                      ? getAviaCompanyLink({yandexAviaUrl})
                                      : getAviaCompanyLink({id, tld, language}),
                              }
                            : {},
                    content: companyTitle,
                });
            }

            return result;
        },
        [] as ITransportFeature[],
    );
}
