import {FilterTransportType} from '../../transportType';
import {ISubtypeInfo} from '../../../interfaces/search/ISubtypeInfo';
import SearchSegment from '../../../interfaces/state/search/SearchSegment';
import ISearchContext from '../../../interfaces/state/search/ISearchContext';
import SegmentSubtypeCode from '../../../interfaces/segment/SegmentSubtypeCode';

import groupFilteredSegments from '../groupFilteredSegments';
import highSpeedTrainFilter from '../../filters/highSpeedTrain';

/**
 * Возвращает подтипы для электричек
 */
const getSuburbanSubtypes = (segments: SearchSegment[]): ISubtypeInfo[] => {
    const subtypesObject: Partial<Record<SegmentSubtypeCode, ISubtypeInfo>> =
        {};

    segments.forEach(segment => {
        const {transport} = segment;
        const {subtype} = transport || {};

        if (subtype && subtype.code && subtype.title) {
            const {code} = subtype;
            const subtypes = subtypesObject[code];

            if (subtypes) {
                subtypes.segments.push(segment);
            } else {
                const {title} = subtype;

                subtypesObject[code] = {title, segments: [segment], key: code};
            }
        }
    });

    return Object.values(subtypesObject) as ISubtypeInfo[];
};

/**
 * Возвращает подтипы для поездов
 */
const getTrainSubtypes = (
    segments: SearchSegment[],
    context: ISearchContext,
): ISubtypeInfo[] => {
    return groupFilteredSegments({
        filterManager: highSpeedTrainFilter,
        segments,
        context,
    });
};

/**
 * Возвращает объект с сегментами, разбитыми по сабтипам
 */
export default function getSearchSubtypes(
    segments: SearchSegment[],
    context: ISearchContext,
): ISubtypeInfo[] {
    const {transportType} = context;

    switch (transportType) {
        case FilterTransportType.suburban:
            return getSuburbanSubtypes(segments);
        case FilterTransportType.train:
            return getTrainSubtypes(segments, context);

        default:
            return [];
    }
}
