import {SUBTYPE} from './features';

import ISegmentThreadBase from '../../../interfaces/segment/ISegmentThreadBase';
import ISegmentTransport from '../../../interfaces/segment/ISegmentTransport';
import ITransportFeature from '../../../interfaces/lib/segments/ITransportFeature';
import SegmentSubtypeCode from '../../../interfaces/segment/SegmentSubtypeCode';

import {clearMarkup} from '../../stringUtils';

import keyset from '../../../i18n/segment';

// Вернёт данные о подтипе сегмента
export default function getSubtype(
    transport: ISegmentTransport,
    thread?: ISegmentThreadBase | null,
    isSuburbanSearchResult?: boolean,
): ITransportFeature | null {
    const {subtype} = transport;
    const {isExpress = false} = thread || {};

    const subtypeTitle = subtype && subtype.title;
    const isSubtypeOrExpress =
        (subtypeTitle && subtype && subtype.id !== transport.id) || isExpress;

    // Для поездов-ласточек дальнего следования нужно добавлять "(билеты с указанием мест)"
    // на выдаче электричками (Тикет: https://st.yandex-team.ru/RASPFRONT-8490)
    const isLastDal =
        subtype?.code === SegmentSubtypeCode.lastochkaDal &&
        isSuburbanSearchResult;
    const isLastDalSubtypeTitle = isLastDal
        ? `${subtypeTitle} ${keyset('tickets-with-seats')}`
        : undefined;

    if (!isSubtypeOrExpress) {
        return null;
    }

    const content = subtypeTitle
        ? clearMarkup(isLastDalSubtypeTitle || subtypeTitle)
        : keyset('express');

    return {
        type: SUBTYPE,
        props: {
            style:
                subtype && subtype.titleColor
                    ? {color: subtype.titleColor}
                    : {},
        },
        content,
    };
}
