import {TransportType} from '../../transportType';

/*
Вернёт признак наличия электронной регистрации для сегмента.
Насколько нам известно электронная регистрация есть только у
поездатых и автобусных сегментов.
*/
export default function hasElectronicRegistration(
    transportType: TransportType,
    electronicTicket?: boolean, // из свойства tariffs сегмента
): boolean {
    if (
        transportType !== TransportType.train &&
        transportType !== TransportType.bus
    ) {
        return false;
    }

    return Boolean(electronicTicket);
}
