import ISearchMeta from '../../interfaces/state/search/ISearchMeta';
import ITransferFromApi from '../../interfaces/transfer/ITransferFromApi';
import ITransfer from '../../interfaces/transfer/ITransfer';

import patchSegments from './patchSegments';
import mergeTransfers from '../search/mergeTransfers';

export default function updateTransfer(
    transferA: ITransfer,
    transferB: ITransferFromApi,
    meta: ISearchMeta,
): ITransfer {
    const transfer = mergeTransfers(transferA, transferB);

    if (transfer === transferA) {
        return transferA;
    }

    return patchSegments({
        segments: [transfer],
        meta,
    })[0] as ITransfer;
}
