import SearchSegment from '../../interfaces/state/search/SearchSegment';
import ITransferFromApi from '../../interfaces/transfer/ITransferFromApi';
import ISearchMeta from '../../interfaces/state/search/ISearchMeta';

import isTransfer from './isTransfer';
import updateTransfer from './updateTransfer';
import patchSegments from './patchSegments';

/* Производит добавление новых пересадок и обновление тарифов у уже существующих */
export default function updateTransfers(
    baseSegments: SearchSegment[],
    transfers: ITransferFromApi[],
    meta: ISearchMeta,
): SearchSegment[] {
    const newTransfersById: Map<string, ITransferFromApi> = new Map(
        transfers.map(transfer => [transfer.id, transfer]),
    );
    // сначала пройдемся по существующим пересадкам и обновим их, сохраняя порядок сегментов
    const updatedSegments = baseSegments.map(element => {
        if (!isTransfer(element)) {
            return element;
        }

        const newTransfer = newTransfersById.get(element.id);

        if (!newTransfer) {
            return element;
        }

        newTransfersById.delete(element.id);

        return updateTransfer(element, newTransfer, meta);
    });

    return [
        ...updatedSegments,
        ...patchSegments({
            segments: [...newTransfersById.values()],
            meta,
        }),
    ];
}
