import {TRAIN_TARIFF_CLASSES} from '../segments/tariffClasses';

import IPrice from '../../interfaces/state/IPrice';
import SearchSegment from '../../interfaces/state/search/SearchSegment';

import gatherMinPriceData from '../segments/gatherMinPriceData';

type TMinPriceByClass = {
    tariffClass: string;
    price: IPrice;
};

export const getMinPricesByClass = (
    segments: SearchSegment[],
): TMinPriceByClass[] => {
    const result: TMinPriceByClass[] = [];

    TRAIN_TARIFF_CLASSES.forEach(tariffClass => {
        const classMinPriceData = gatherMinPriceData(segments, {
            tariffClassKeys: [tariffClass],
        });

        if (classMinPriceData) {
            const {price} = classMinPriceData;

            result.push({tariffClass, price});
        }
    });

    return result;
};
