import gatherMinPriceData from '../segments/gatherMinPriceData';
import {getSemanticPrice} from '../format/formatPrice';

/**
 * Возвращает JSON LD продукта для SEO
 * @see https://developers.google.com/search/docs/data-types/products
 * @param {string} title - заголовок продукта (например Расписание рейсов Москва - Екатеринбург)
 * @param {Object[]} segments - массив сегментов
 * @return {Object | null} - разметка в формате JSON LD
 */
export default function getProductSemanticMarkup(title, segments = []) {
    const minPriceData = gatherMinPriceData(segments);

    if (!minPriceData) {
        return null;
    }

    const {price} = minPriceData;

    return {
        '@context': 'http://schema.org/',
        '@type': 'Product',
        name: title,
        offers: {
            '@type': 'AggregateOffer',
            lowPrice: getSemanticPrice(price),
            priceCurrency: price.currency,
        },
    };
}
