import {ISubtypeInfo} from '../../interfaces/search/ISubtypeInfo';

import formatPrice from '../format/formatPrice';
import gatherMinPriceData from '../segments/gatherMinPriceData';

import descriptionKeyset from '../../i18n/search-description-v2';

/**
 * Возвращает строку с ценами для подтипов
 */
export const getSubtypesWithPrices = (
    searchSubtypes: ISubtypeInfo[],
): string => {
    if (!searchSubtypes || !searchSubtypes.length) {
        return '';
    }

    const result: string[] = [];

    searchSubtypes.forEach(subtype => {
        const {title: subtypeTitle, segments: subtypeSegments} = subtype;
        const minSubtypePrice = gatherMinPriceData(subtypeSegments);
        const {price} = minSubtypePrice || {};

        if (price) {
            const formattedPrice = formatPrice(price, {round: true});
            const subtypeText = descriptionKeyset('element-from-value', {
                title: subtypeTitle,
                value: formattedPrice,
            });

            result.push(subtypeText);
        }
    });

    return result.join(', ');
};
