import {
    TRAIN_TICKETS,
    PUBLIC_TRANSPORT,
    PROMOTIONS,
    ABOUT_TRAINS,
} from './constants/homepageBlocks';
import {TLD_RU, TLD_UA, TLD_BY, TLD_KZ, TLD_NET} from './tlds';

const blocksDictionary = {
    [TRAIN_TICKETS]: [TLD_RU, TLD_NET],
    [PUBLIC_TRANSPORT]: [TLD_RU, TLD_BY, TLD_UA, TLD_KZ, TLD_NET],
    [PROMOTIONS]: [TLD_RU, TLD_BY, TLD_KZ, TLD_NET],
    [ABOUT_TRAINS]: [TLD_RU, TLD_NET],
};

/**
 * Возвращает ответ - стоит ли показывать блок для определенной страны
 * @param {string} blockName - имя блока
 * @param {string} tld - страна
 * @return {boolean}
 */
export default function shouldShowBlockForCountry(blockName, tld) {
    return blocksDictionary[blockName].includes(tld);
}
