import SearchSegment from '../../interfaces/state/search/SearchSegment';

// Строит вектор индексов сегментов, отсортированных в порядке возрастания времени отправления
//      без учета даты.
export default function buildArchivalSegmentsVector(
    segments: SearchSegment[],
): number[] {
    return Array.from({length: segments.length}, (item, index) => index).sort(
        (indexA, indexB) => {
            const segmentADepartureTime =
                segments[indexA].departure.split('T')[1];
            const segmentBDepartureTime =
                segments[indexB].departure.split('T')[1];

            if (segmentADepartureTime > segmentBDepartureTime) {
                return 1;
            }

            if (segmentADepartureTime < segmentBDepartureTime) {
                return -1;
            }

            return 0;
        },
    );
}
