import alphaBeticalSort from './alphaBeticalSort';

type RegExpElement = {value: RegExp; index: number};

/*
Возвращает функцию для сортировки.
Можно передать как массив конкретных значений, так и регулярные выражения.
Чтобы понять как работает, смотрите тесты.
*/
export default function getSortFunction(
    arrayWithOrder: any[],
): (a: any, b: any) => number {
    // Создаем вспомогательный массив для регулярок
    const regExps = arrayWithOrder.reduce<RegExpElement[]>(
        (result, value, index) => {
            if (value instanceof RegExp) {
                result.push({value, index});
            }

            return result;
        },
        [],
    );

    return (a, b) => {
        if (a === b) {
            return 0;
        }

        const aPosition = findIndex(a, arrayWithOrder, regExps);
        const bPosition = findIndex(b, arrayWithOrder, regExps);

        // Обработка случая, когда оба значения подходят под одно регулярное выражение
        if (
            aPosition !== -1 &&
            bPosition !== -1 &&
            aPosition === bPosition &&
            arrayWithOrder[aPosition] instanceof RegExp
        ) {
            return alphaBeticalSort(a, b);
        }

        // Элементы, которых нет в массиве с порядком, опускаются вниз с учетом изначального порядка
        if (aPosition === -1 && bPosition === -1) {
            return 0;
        }

        if (aPosition !== -1 && bPosition === -1) {
            return -1;
        }

        if (aPosition === -1 && bPosition !== -1) {
            return 1;
        }

        if (aPosition === bPosition) {
            return 0;
        }

        return aPosition < bPosition ? -1 : 1;
    };
}

function findIndex(
    value: any,
    arrayWithOrder: any[],
    regExps: RegExpElement[],
): number {
    const index = arrayWithOrder.findIndex(name => name === value);

    if (index !== -1) {
        return index;
    }

    if (typeof value !== 'string') {
        return -1;
    }

    const regExpElement = regExps.find(regExp => regExp.value.test(value));

    if (!regExpElement) {
        return -1;
    }

    return regExpElement.index;
}
