'use strict';

import {DEFAULT_SORT, SORT_FIELDS} from './utils';

export function parseSorting(text) {
    if (!text) {
        return {...DEFAULT_SORT};
    }

    const {by, reverse} = text.startsWith('-')
        ? {by: text.substr(1), reverse: true}
        : {by: text, reverse: false};

    const result = SORT_FIELDS.includes(by) ? {by, reverse} : {...DEFAULT_SORT};

    return result;
}
