/**
 * Сортирует список направлений, возвращает новый список
 * @param {Object[]} directions
 * @param {string} locale
 * @return {Object[]}
 */
export default function sortDirections(directions, locale) {
    return directions
        .slice()
        .sort((dir1, dir2) =>
            dir1.title.localeCompare(dir2.title, locale, {caseFirst: 'upper'}),
        );
}
