const BUS_STATION_TYPE_ID = 1;
const STATION_TYPE_ID = 10;

export function compareStations(stationA, stationB) {
    return stationA.title.toLowerCase() > stationB.title.toLowerCase() ? 1 : -1;
}

export function isMainBusStation({station_type: type}) {
    return type.id === STATION_TYPE_ID || type.id === BUS_STATION_TYPE_ID;
}

export function compareBusStations(stationA, stationB) {
    const aIsMain = isMainBusStation(stationA);
    const bIsMain = isMainBusStation(stationB);

    if (aIsMain === bIsMain) {
        return compareStations(stationA, stationB);
    }

    return aIsMain ? -1 : 1;
}

export function sort(stations) {
    if (stations[0] && stations[0].t_type === 'bus') {
        return stations.sort(compareBusStations);
    }

    return stations.sort(compareStations);
}
